/****************************************************************************
                       Microsoft RPC
                Copyright Microsoft Corp. 1992-1996
                  object call_as Example

    FILE:       call_as.c

    PURPOSE:    [call_as] Glue routines for proxy DLL

    FUNCTIONS:  IHelloCallAs_HelloProc_Proxy
                IHelloCallAs_HelloProc_Stub

    COMMENTS:   This version of the Ole2 distributed application that
                prints "hello, world" (or other string) on the server
                features a non-rpcable custom interface being remoted with
                [call_as].

****************************************************************************/

#include <stdio.h>
#include "rpcproxy.h"
#define INC_OLE2
#include <windows.h>
#include "callas.h" // this is the header file generated by midl


// this file provides the conversion routines between the remoted
// interface and the local view of the interface.  This allows an interface
// with apparently non-remotable methods to be remoted.  The conversions
// may be similar to transmit_as or represent_as conversions, or they
// can be more dramatic, such as synthesizing additional parameters, etc.
// in this case, the return type is changed


// The IHelloCallAs_HelloProc_Proxy routine goes into the vtable for
// the clients IHelloCallAs objects, so the client calls this first
// when they invoke the HelloProc method on an IHelloCallAs object.

// The IHelloCallAs_HelloProc_Stub routine is called by the server
// side stub when the remoted call comes in.  It does any conversions
// needed and then invokes the real HelloProc method on the servers
// IHelloCallAs object implementation.

// both of these must be provided in the proxy DLL, because the
// SAME proxy dll is used for both the client and server sides.




// this routine goes into the client side "proxy" object for the server.
// it has the parameter list of the non-remoted (local) flavor of the
// call, and converts it to the remoted flavor of the call.  It can also
// do special case memory management, have debugging hooks, etc.

MyBoolean
STDMETHODCALLTYPE
IHelloCallAs_HelloProc_Proxy (
     IHelloCallAs        * pThis,
     unsigned char * pszString
    )
{
    HRESULT     rc;

    printf("Proxy: %s\n", pszString);
    rc = IHelloCallAs_RemoteHelloProc_Proxy(pThis, pszString);

    return FAILED(rc);
}


// this routine is directly called by the server-side stub code.
// it is called with the remoted param list, and must convert to the
// local flavor.  As with the proxy side routine, this one can also
// do special case memory management, have debugging hooks, etc.

HRESULT
RPC_ENTRY
IHelloCallAs_HelloProc_Stub (
     IHelloCallAs        * pThis,
     unsigned char * pszString
     )
{
    MyBoolean   rc;

    rc = pThis->lpVtbl->HelloProc(pThis, pszString);
    return rc ? S_OK : E_FAIL;
}
